<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\ClassRoom;
use Illuminate\Http\Request;
use App\Models\StudentSubscribe;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Services\Registration;
use App\Models\Certificate;
use PhpOffice\PhpSpreadsheet\Calculation\TextData\Format;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat\DateFormatter;

class DashboardController extends Controller
{

    public function __construct()
    {
        // $this->middleware('auth:authors');      // Added
    }

    public function index()
    {
        $rooms = StudentSubscribe::with('room')->where('student_id',Auth::user()->id)->get();
        $certificates = Certificate::where('student_id',Auth::user()->id)->get();

        return view('student.dashboard')->with([
            'rooms'=>$rooms,
            'certificates'=>$certificates
        ]);
    }

    public function completedClasses()
    {
        $rooms = StudentSubscribe::with('room')->where('student_id',Auth::user()->id)->get();
        $certificates = Certificate::where('student_id',Auth::user()->id)->get();

        return view('student.completed-classes')->with([
            'rooms'=>$rooms,
            'certificates'=>$certificates
        ]);
    }

    public function standingClasses()
    {
        $rooms = StudentSubscribe::with('room')->where('student_id',Auth::user()->id)->get();
        $certificates = Certificate::where('student_id',Auth::user()->id)->get();

        return view('student.standing-classes')->with([
            'rooms'=>$rooms,
            'certificates'=>$certificates
        ]);
    }

    public function admin()
    {
        $trainers = User::train()->get()->count();
        $students = User::student()->get()->count();
        $rooms = ClassRoom::get()->count();
        $certificates = Certificate::get()->count();
        return view('admin.dashboard')->with([
            'trainers'=>$trainers,
            'students'=>$students,
            'rooms'=>$rooms,
            'certificates'=>$certificates,
        ]);
    }

    public function trainer()
    {
        $rooms = ClassRoom::with('course', 'trainer', 'students')->where('trainer_id',Auth::user()->id)->get();
        return view('trainer.dashboard')->with('rooms',$rooms);
    }
    public function coordinator()
    {
        $rooms = ClassRoom::with('course', 'trainer', 'students')->where('coordinator_id',Auth::user()->id)->get();
        return view('trainer.dashboard')->with('rooms',$rooms);
    }
    public function listUser()
    {
        $users = User::get();
        return view('users.list')->with('users',$users);
    }

    public function store(Request $request)
    {
     
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            
        ], [
            'name.required' => 'يرجى اضافة الاسم .',
            'email.required' => 'يرجى اضافة الإيميل .',
            'email.email' => 'يرجى اضافة إيميل صحيح .',
            'email.unique' => 'هذا الإيميل مستخدم من قبل  .']);
        try {

            $newUser = new User();
            $newUser->name = $request->name;
            $newUser->email = $request->email;
            if (!$request->nameCertificate == null) {
                $newUser->certificate_name = $request->nameCertificate;
            }

            if (!$request->phone == null) {
                $newUser->phone = $request->phone;
            }
            if (!$request->role == null) {
                $newUser->role = $request->role;
            }
            $newUser->save();
            if (Registration::sendMails($newUser)) {
                return back()->with(['success' => 'تم إضافة بيانات المستخدم بنجاح']);
            }

            return back()->with(['warning' => 'تم إضافة بيانات المستخدم ولم يرسل ايميل التفعيل']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم إضافة بيانات المستخدم  ']);
        }
    }
    /**
     * [Description for update]
     *
     * @param Request $request
     * 
     * @return [type]
     * 
     */
    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            
        ], [
            'name.required' => 'يرجى اضافة الاسم .',
            'email.required' => 'يرجى اضافة الإيميل .',
            'email.email' => 'يرجى اضافة إيميل صحيح .',
            'email.unique' => 'هذا الإيميل مستخدم من قبل  .']);
        try {

            $updateUser = User::find($request->id);
            $updateUser->name = $request->name;
            $updateUser->email = $request->email;
            if (!$request->nameCertificate == null) {
                $updateUser->certificate_name = $request->nameCertificate;
            }

            if (!$request->phone == null) {
                $updateUser->phone = $request->phone;
            }
            if (!$request->role == null) {
                $updateUser->role = $request->role;
            }
            $updateUser->update();
                return back()->with(['success' => 'تم تحديث بيانات المستخدم بنجاح']);
            

        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم تحديث بيانات المستخدم  ']);
        }
    }
    /**
     * [Description for delete]
     *
     * @param Request $request
     * 
     * @return [type]
     * 
     */
    public function delete(Request $request)
    {
        try {
            User::find($request->id)->delete();
            return back()->with(['success' => 'تمت حذف المستخدم بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم حذف المستخدم ']);
        }
    }
    /**
     * [This method using to active and not active ]
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function toggle(Request $request)
    {
        try {
            $student = User::find($request->id);
            $student->is_active *= -1;
            $student->save();
            return back()->with(['success' => 'تمت تحديث البيانات بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات']);
        }
    }

}
